/******************************************************************************/
/*                                                                            */
/* GenErrorText.rex - Generate StringTable for better ANSI ERRORTEXT support  */
/* =========================================================================  */
/*                                                                            */
/* This program is part of the Rexx Parser package                            */
/* [See https://rexx.epbcn.com/rexx-parser/]                                  */
/*                                                                            */
/* Copyright (c) 2024-2026 Josep Maria Blasco <josep.maria.blasco@epbcn.com>  */
/*                                                                            */
/* License: Apache License 2.0 (https://www.apache.org/licenses/LICENSE-2.0)  */
/*                                                                            */
/* Version history:                                                           */
/*                                                                            */
/* Date     Version Details                                                   */
/* -------- ------- --------------------------------------------------------- */
/* 20250426    0.2b Initial release                                           */
/* 20250602    0.2c Take into account substitution position                   */
/* 20251226    0.4a Send error messages to .error, not .output                */
/*                                                                            */
/******************************************************************************/

  rexxMsg = "rexxMsg.xml" -- Must be in same directory

  messages = CharIn(rexxMsg, 1, Chars(rexxMsg))
  Call Stream rexxMsg,"c","Close"

  messages = messages               -
            ~changeStr("0d"x," ")   -
            ~changeStr("0a"x," ")   -
            ~space                  -
            ~makeArray("<Message>")

  nMessages = 0

  Say "/******************************************************************************/"
  Say "/*                                                                            */"
  Say "/* ANSI.ErrorText.cls - Extended ANSI ErrorText support                       */"
  Say "/* ====================================================                       */"
  Say "/*                                                                            */"
  Say "/* This program is part of the Rexx Parser package                            */"
  Say "/* [See https://rexx.epbcn.com/rexx-parser/]                                  */"
  Say "/*                                                                            */"
  Say "/* Copyright (c) 2024-2026 Josep Maria Blasco <josep.maria.blasco@epbcn.com>  */"
  Say "/*                                                                            */"
  Say "/* License: Apache License 2.0 (https://www.apache.org/licenses/LICENSE-2.0)  */"
  Say "/*                                                                            */"
  Say "/* Version history:                                                           */"
  Say "/*                                                                            */"
  Say "/* This program is automatically generated by the GenErrorText utility,       */"
  Say "/* which is located in the bin/resources directory.                           */"
  Say "/*                                                                            */"
  Say "/* DO NOT EDIT DIRECTLY -- ALL CHANGES WILL BE LOST                           */"
  Say "/*                                                                            */"
  Say "/******************************************************************************/"

  Say "  Secondary = .StringTable~new"
  Say

  Do i = 2 To messages~items
    Parse Value messages[i] With "<Code>"major"</Code>" "<Subcodes>"subCodes"</Subcodes>"
  If major > 99 Then Leave
    subMessages = subCodes~makeArray("<SubMessage>")
    Do j = 2 To subMessages~items
      Parse Value subMessages[j] With "<Subcode>"minor"</Subcode>" "<Text>"text"</Text>"
      text = text -
        ~changeStr("<q>"  ,'"')~changeStr("</q>" ,'"') -
        ~changeStr("<sq/>","'")~changeStr("<dq/>",'"') -
        ~changeStr("&gt;",'>')~changeStr("&lt;",'<')   -
        ~changeStr("&apos;","'")
      If Pos("&",text) > 0 Then Do
       .Error~Say( "Unexpected '&' in message text" major"."minor":" )
       .Error~Say( text                                              )
        Exit 1
      End
      Do While Pos("<Sub ",Text) >  0
        position = ""
        Parse var text before"<Sub" things "/>"after
        Parse var things 'position="'position'"'
        If \DataType(position, "W") Then Do
         .Error~Say( "Position in text of" major"."minor "is not an integer." )
          Exit 1
        End
        Parse var things 'name="'name'"'
        If name = "" Then Do
         .Error~Say( "Name not found for" major"."minor"." )
          Exit 1
        End
        If position = "" Then Do
         .Error~Say( "Position not found for" major"."minor"." )
          Exit 1
        End
        text = before"<"position":"name">"after
      End
      Say '  Secondary["'major"."minor'"] = "'ChangeStr('"',text,'""')'"'
      nMessages += 1
    End
  End
  Say
  Say " .environment~ANSI.ErrorText.Secondary = Secondary -- Messages processed:" nMessages
  Say

  Say '::Routine ANSI.ErrorText Public'
  Say '  Use Arg code'
  Say '  Parse Var code major"."minor'
  Say '  If minor \== "" Then minor = Right(minor, 3, "0")'
  Say '  If Arg() == 1 Then Do'
  Say '    If minor == "" Then Return ErrorText(major)'
  Say '    Return .ANSI.ErrorText.Secondary[major"."minor]'
  Say '  End'
  Say '  If minor == "" Then Do'
  Say '   .Error~Say( "Routine ANSI.ErrorText called with substitutions but no minor error code." )'
  Say '    Raise HALT'
  Say '  End'
  Say '  message = .ANSI.ErrorText.Secondary[major"."minor]'
  Say '  If Arg(2,"O") Then Return message'
  Say '  substitutions = Arg(2)'
  Say '  Do Counter c arg Over substitutions'
  Say '    If Pos("<"c":",message) == 0 Then Leave'
  Say '    Parse Var message before ("<"c":") ">"after'
  Say '    message = before || arg || after'
  Say '  End'
  Say '  Return message'
  Say
  Say
  Say "--" nMessages "secondary messages processed."
  Say "--"
  Say "-- Use the following instruction to regenerate secondary message support:"
  Say "--"
  sep = .File~separator
  Say "--   GenErrorText > .."sep"ANSI.ErrorText.cls "

Exit