/******************************************************************************/
/*                                                                            */
/* ANSI.ErrorText.cls - Extended ANSI ErrorText support                       */
/* ====================================================                       */
/*                                                                            */
/* This program is part of the Rexx Parser package                            */
/* [See https://rexx.epbcn.com/rexx-parser/]                                  */
/*                                                                            */
/* Copyright (c) 2024-2026 Josep Maria Blasco <josep.maria.blasco@epbcn.com>  */
/*                                                                            */
/* License: Apache License 2.0 (https://www.apache.org/licenses/LICENSE-2.0)  */
/*                                                                            */
/* Version history:                                                           */
/*                                                                            */
/* This program is automatically generated by the GenErrorText utility,       */
/* which is located in the bin/resources directory.                           */
/*                                                                            */
/* DO NOT EDIT DIRECTLY -- ALL CHANGES WILL BE LOST                           */
/*                                                                            */
/******************************************************************************/
  Secondary = .StringTable~new

  Secondary["3.001"] = "Failure during initialization: File ""<1:filename>"" is unreadable."
  Secondary["3.900"] = "<1:message>."
  Secondary["3.901"] = "Failure during initialization: Program ""<1:program>"" was not found."
  Secondary["3.902"] = "Error writing output file ""<1:file>""."
  Secondary["3.903"] = "Program ""<1:program_name>"" cannot be run by this version of the REXX interpreter."
  Secondary["3.905"] = "Encoded compiled program ""<1:program_name>"" cannot be decoded."
  Secondary["4.001"] = "Program interrupted with <1:condition> condition."
  Secondary["4.900"] = "<1:message>."
  Secondary["5.900"] = "<1:message>."
  Secondary["6.001"] = "Unmatched comment delimiter (""/*"") on line <1:line_number>."
  Secondary["6.002"] = "Unmatched single quote (')."
  Secondary["6.003"] = "Unmatched double quote ("")."
  Secondary["6.900"] = "<1:message>."
  Secondary["7.001"] = "SELECT on line <1:line_number> requires WHEN."
  Secondary["7.002"] = "SELECT on line <1:line_number> requires WHEN, OTHERWISE, or END."
  Secondary["7.003"] = "All WHEN expressions of SELECT are false; OTHERWISE expected."
  Secondary["8.001"] = "THEN has no corresponding IF or WHEN clause."
  Secondary["8.002"] = "ELSE has no corresponding THEN clause."
  Secondary["9.001"] = "WHEN has no corresponding SELECT."
  Secondary["9.002"] = "OTHERWISE has no corresponding SELECT."
  Secondary["10.001"] = "END has no corresponding DO, LOOP, or SELECT."
  Secondary["10.002"] = "Symbol following END (""<1:symbol>"") must match block specification name (""<2:name>"") on line <3:line_number> or be omitted."
  Secondary["10.003"] = "END corresponding to block on line <2:symbol> must not have a symbol following it because there is no LABEL or control variable; found ""<1:line_number>""."
  Secondary["10.004"] = "Symbol following END (""<1:symbol>"") must match LABEL of SELECT specification (""<2:name>"") on line <3:line_number> or be omitted."
  Secondary["10.005"] = "END must not immediately follow THEN."
  Secondary["10.006"] = "END must not immediately follow ELSE."
  Secondary["10.007"] = "END corresponding to SELECT on line <2:symbol> must not have a symbol following it because there is no LABEL; found ""<1:line_number>""."
  Secondary["11.001"] = "Insufficient control stack space; cannot continue execution."
  Secondary["11.900"] = "<1:message>."
  Secondary["13.001"] = "Incorrect character in program ""<1:character>"" ('<2:hex_character>'X)."
  Secondary["13.900"] = "<1:message>."
  Secondary["14.001"] = "DO instruction on line <1:line_number> requires matching END."
  Secondary["14.002"] = "SELECT instruction on line <1:line_number> requires matching END."
  Secondary["14.003"] = "THEN on line <1:line_number> must be followed by an instruction."
  Secondary["14.004"] = "ELSE on line <1:line_number> must be followed by an instruction."
  Secondary["14.005"] = "DO or LOOP instruction on line <1:line_number> requires matching END."
  Secondary["14.901"] = "OTHERWISE on line <1:line_number> requires matching END."
  Secondary["15.001"] = "Incorrect location of whitespace character in position <1:position> in hexadecimal string."
  Secondary["15.002"] = "Incorrect location of whitespace character in position <1:position> in binary string."
  Secondary["15.003"] = "Only 0-9, a-f, A-F, and whitespace characters are valid in a hexadecimal string; found ""<1:character>""."
  Secondary["15.004"] = "Only 0, 1, and whitespace characters are valid in a binary string; found ""<1:character>""."
  Secondary["15.005"] = "Hexadecimal strings must be grouped in units that are multiples of two characters."
  Secondary["15.006"] = "Binary strings must be grouped in units that are multiples of four characters."
  Secondary["16.001"] = "Label ""<1:label_name>"" not found."
  Secondary["17.001"] = "PROCEDURE is valid only when it is the first instruction executed after an internal CALL or function invocation."
  Secondary["17.901"] = "INTERPRET data must not contain PROCEDURE."
  Secondary["18.001"] = "IF instruction on line <1:line_number> requires matching THEN clause."
  Secondary["18.002"] = "WHEN instruction on line <1:line_number> requires matching THEN clause."
  Secondary["19.001"] = "String or symbol expected after ADDRESS keyword."
  Secondary["19.002"] = "String or symbol expected after CALL keyword."
  Secondary["19.003"] = "String or symbol expected after NAME keyword."
  Secondary["19.004"] = "String or symbol expected after SIGNAL keyword."
  Secondary["19.006"] = "String or symbol expected after TRACE keyword."
  Secondary["19.007"] = "String or symbol expected after PARSE keyword."
  Secondary["19.900"] = "<1:message>."
  Secondary["19.901"] = "String or symbol expected after ::CLASS keyword."
  Secondary["19.902"] = "String or symbol expected after ::METHOD keyword."
  Secondary["19.903"] = "String or symbol expected after ::ROUTINE keyword."
  Secondary["19.904"] = "String or symbol expected after ::REQUIRES keyword."
  Secondary["19.905"] = "String expected after EXTERNAL keyword."
  Secondary["19.906"] = "String or symbol expected after METACLASS keyword."
  Secondary["19.907"] = "String or symbol expected after SUBCLASS keyword."
  Secondary["19.908"] = "String or symbol expected after INHERIT keyword."
  Secondary["19.909"] = "String or symbol expected after tilde (~)."
  Secondary["19.911"] = "String or symbol expected after superclass colon (:)."
  Secondary["19.912"] = "String or symbol expected after STREAM keyword."
  Secondary["19.913"] = "String or symbol expected after MIXINCLASS keyword."
  Secondary["19.914"] = "String or symbol expected as ::ATTRIBUTE directive name."
  Secondary["19.915"] = "String or symbol expected as ::CONSTANT directive name."
  Secondary["19.916"] = "String or symbol expected as ::CONSTANT value."
  Secondary["19.917"] = "String or symbol expected as DIGITS value."
  Secondary["19.918"] = "String or symbol expected as FUZZ value."
  Secondary["19.919"] = "String or symbol expected as TRACE value."
  Secondary["19.920"] = "String or symbol expected as ::RESOURCE directive name."
  Secondary["19.921"] = "String or symbol expected after ::RESOURCE END keyword."
  Secondary["19.922"] = "String or symbol expected after <1:keyword> keyword."
  Secondary["19.923"] = "Symbol or string expected as ::ANNOTATE attribute value; found ""<1:name>""."
  Secondary["19.924"] = "Symbol or string expected as ::ANNOTATE attribute value."
  Secondary["19.925"] = "Symbol or string expected after <1:directive> <2:keyword> keyword."
  Secondary["20.900"] = "<1:message>."
  Secondary["20.901"] = "Symbol expected after DROP keyword."
  Secondary["20.902"] = "Symbol expected after EXPOSE keyword."
  Secondary["20.903"] = "Symbol expected after PARSE keyword."
  Secondary["20.904"] = "Symbol expected after PARSE VAR."
  Secondary["20.905"] = "NUMERIC must be followed by one of the keywords DIGITS, FORM, or FUZZ; found ""<1:symbol>""."
  Secondary["20.906"] = "Symbol expected after ""("" of a variable reference."
  Secondary["20.907"] = "Symbol expected after LEAVE keyword."
  Secondary["20.908"] = "Symbol expected after ITERATE keyword."
  Secondary["20.909"] = "Symbol expected after END keyword."
  Secondary["20.911"] = "Symbol expected after ON keyword."
  Secondary["20.912"] = "Symbol expected after OFF keyword."
  Secondary["20.913"] = "Symbol expected after USE ARG."
  Secondary["20.914"] = "Symbol expected after RAISE keyword."
  Secondary["20.915"] = "Symbol expected after USER keyword."
  Secondary["20.916"] = "Symbol expected after ::."
  Secondary["20.917"] = "Symbol expected after superclass colon (:)."
  Secondary["20.918"] = "Symbol expected after LABEL keyword."
  Secondary["20.919"] = "Symbol expected as ::ANNOTATE attribute name; found ""<1:name>""."
  Secondary["20.920"] = "Symbol expected after NAMESPACE keyword."
  Secondary["20.921"] = "Symbol expected as a class name of qualified class name."
  Secondary["20.922"] = "Symbol expected as a routine name of qualified CALL instruction."
  Secondary["20.923"] = "Symbol expected as a name of namespace-qualified symbol."
  Secondary["20.924"] = "Symbol expected for the ::ANNOTATE type."
  Secondary["20.925"] = "Symbol expected after the FORM keyword."
  Secondary["20.926"] = "Symbol expected after the DELEGATE keyword."
  Secondary["20.927"] = "Symbol expected after USE LOCAL."
  Secondary["20.928"] = "Symbol expected as an indirect variable name; found ""<1:token>""."
  Secondary["20.929"] = "Symbol expected after <1:keyword> keyword."
  Secondary["20.930"] = "Simple variable or stem symbol expected after > or < prefix operator; found <1:token>."
  Secondary["20.931"] = "Simple variable or stem symbol expected after > or < USE ARG reference operator; found <1:token>."
  Secondary["20.932"] = "Stem symbol expected after STEM keyword."
  Secondary["20.933"] = "Symbol expected after WITH keyword."
  Secondary["20.934"] = "Symbol expected after COUNTER keyword."
  Secondary["20.935"] = "Symbol expected after the NUMERIC subdirective keyword."
  Secondary["21.900"] = "<1:message>."
  Secondary["21.901"] = "Data must not follow the NOP keyword; found ""<1:data>""."
  Secondary["21.902"] = "Data must not follow the SELECT keyword; found ""<1:data>""."
  Secondary["21.903"] = "Data must not follow the NAME trap name; found ""<1:data>""."
  Secondary["21.904"] = "Data must not follow the condition name; found ""<1:data>""."
  Secondary["21.905"] = "Data must not follow the SIGNAL label name; found ""<1:data>""."
  Secondary["21.906"] = "Data must not follow the TRACE setting; found ""<1:data>""."
  Secondary["21.907"] = "Data must not follow the LEAVE name; found ""<1:data>""."
  Secondary["21.908"] = "Data must not follow the ITERATE name; found ""<1:data>""."
  Secondary["21.909"] = "Data must not follow the END name; found ""<1:data>""."
  Secondary["21.911"] = "Data must not follow the NUMERIC FORM specification; found ""<1:data>""."
  Secondary["21.912"] = "Data must not follow the GUARD OFF specification; found ""<1:data>""."
  Secondary["21.913"] = "Data must not follow the ::CONSTANT value; found ""<1:data>""."
  Secondary["21.914"] = "Data must not follow the ::RESOURCE directive; found ""<1:data>""."
  Secondary["22.001"] = "Incorrect character string ""<1:character_string>"" ('<2:hex_string>'X)."
  Secondary["22.900"] = "<1:message>."
  Secondary["22.901"] = "Incorrect double-byte character."
  Secondary["23.001"] = "Incorrect data string ""<1:string>"" ('<2:hex_string>'X)."
  Secondary["23.900"] = "<1:message>."
  Secondary["24.001"] = "TRACE request letter must be one of ""ACEFILNOR""; found ""<1:value>""."
  Secondary["24.901"] = "Numeric TRACE requests are valid only from interactive debugging."
  Secondary["25.001"] = "CALL ON must be followed by one of the keywords ERROR, FAILURE, HALT, NOTREADY, USER, or ANY; found ""<1:word>""."
  Secondary["25.002"] = "CALL OFF must be followed by one of the keywords ERROR, FAILURE, HALT, NOTREADY, USER, or ANY; found ""<1:word>""."
  Secondary["25.003"] = "SIGNAL ON must be followed by one of the keywords ERROR, FAILURE, HALT, LOSTDIGITS, NOTREADY, NOMETHOD, NOSTRING, NOVALUE, SYNTAX, USER, or ANY; found ""<1:word>""."
  Secondary["25.004"] = "SIGNAL OFF must be followed by one of the keywords ERROR, FAILURE, HALT, LOSTDIGITS, NOTREADY, NOMETHOD, NOSTRING, NOVALUE, SYNTAX, USER, or ANY; found ""<1:word>""."
  Secondary["25.011"] = "NUMERIC FORM must be followed by one of the keywords SCIENTIFIC or ENGINEERING; found ""<1:word>""."
  Secondary["25.012"] = "PARSE must be followed by optional keywords LOWER or UPPER, by an optional keyword CASELESS, and by one of the keywords ARG, LINEIN, PULL, SOURCE, VALUE, VAR, or VERSION; found ""<1:word>""."
  Secondary["25.015"] = "NUMERIC must be followed by one of the keywords DIGITS, FORM, or FUZZ; found ""<1:word>""."
  Secondary["25.017"] = "PROCEDURE must be followed by the keyword EXPOSE or nothing; found ""<1:word>""."
  Secondary["25.900"] = "<1:message>."
  Secondary["25.901"] = "Unknown keyword on ::CLASS directive; found ""<1:word>""."
  Secondary["25.902"] = "Unknown keyword on ::METHOD directive; found ""<1:word>""."
  Secondary["25.903"] = "Unknown keyword on ::ROUTINE directive; found ""<1:word>""."
  Secondary["25.904"] = "Unknown keyword on ::REQUIRES directive; found ""<1:word>""."
  Secondary["25.905"] = "USE must be followed by the keyword ARG, LOCAL or STRICT; found ""<1:word>""."
  Secondary["25.906"] = "RAISE must be followed by one of the keywords ERROR, FAILURE, HALT, LOSTDIGITS, NOMETHOD, NOSTRING, NOTREADY, NOVALUE, PROPAGATE, SYNTAX, or USER; found ""<1:word>""."
  Secondary["25.907"] = "Unknown keyword on RAISE instruction; found ""<1:word>""."
  Secondary["25.908"] = "Duplicate DESCRIPTION keyword found."
  Secondary["25.909"] = "Duplicate ADDITIONAL or ARRAY keyword found."
  Secondary["25.911"] = "Duplicate RETURN or EXIT keyword found."
  Secondary["25.912"] = "GUARD ON or GUARD OFF must be followed by the keyword WHEN; found ""<1:word>""."
  Secondary["25.913"] = "GUARD must be followed by the keyword ON or OFF; found ""<1:word>""."
  Secondary["25.914"] = "CALL ON condition must be followed by the keyword NAME; found ""<1:word>""."
  Secondary["25.915"] = "SIGNAL ON condition must be followed by the keyword NAME; found ""<1:word>""."
  Secondary["25.916"] = "Unknown keyword on FORWARD instruction; found ""<1:keyword>""."
  Secondary["25.917"] = "Duplicate TO keyword found."
  Secondary["25.918"] = "Duplicate ARGUMENTS or ARRAY keyword found."
  Secondary["25.919"] = "Duplicate RETURN or CONTINUE keyword found."
  Secondary["25.921"] = "Duplicate CLASS keyword found."
  Secondary["25.922"] = "Duplicate MESSAGE keyword found."
  Secondary["25.923"] = "SELECT must be followed by the keyword LABEL or CASE; found ""<1:word>""."
  Secondary["25.924"] = "Unknown keyword on ::OPTIONS directive; found ""<1:word>""."
  Secondary["25.925"] = "Unknown keyword on ::ATTRIBUTE directive; found ""<1:word>""."
  Secondary["25.926"] = "Unknown keyword on ::RESOURCE directive; found ""<1:word>""."
  Secondary["25.927"] = "Unknown keyword following ""<1:keyword>""; found ""<2:word>""."
  Secondary["25.928"] = "Unknown keyword on ::ANNOTATE directive; found ""<1:word>""."
  Secondary["25.929"] = "USE STRICT must be followed by the keyword ARG; found ""<1:word>""."
  Secondary["25.930"] = "Duplicate INPUT keyword found."
  Secondary["25.931"] = "Duplicate OUTPUT keyword found."
  Secondary["25.932"] = "Duplicate ERROR keyword found."
  Secondary["25.933"] = "Acceptable ADDRESS WITH I/O types are NORMAL, STEM, STREAM, and USING; found ""<1:word>""."
  Secondary["25.934"] = "WITH must be followed by one of the keywords INPUT, OUTPUT, or ERROR; found ""<1:word>""."
  Secondary["25.935"] = "Subdirective NUMERIC must be followed by one of the keywords INHERIT or NOINHERIT; found ""<1:symbol>""."
  Secondary["26.002"] = "Value of repetition count expression in DO or LOOP instruction must be zero or a positive whole number; found ""<1:value>""."
  Secondary["26.003"] = "Value of FOR expression in DO or LOOP instruction must be zero or a positive whole number; found ""<1:value>""."
  Secondary["26.004"] = "Positional pattern of PARSE template must be a whole number; found ""<1:value>""."
  Secondary["26.005"] = "DIGITS value must be a positive whole number; found ""<1:value>""."
  Secondary["26.006"] = "FUZZ value must be zero or a positive whole number; found ""<1:value>""."
  Secondary["26.007"] = "Number used in TRACE setting must be a whole number; found ""<1:value>""."
  Secondary["26.008"] = "Operand to the right of the power operator (**) must be a whole number; found ""<1:value>""."
  Secondary["26.011"] = "Result of % operation did not result in a whole number."
  Secondary["26.012"] = "Result of // operation did not result in a whole number."
  Secondary["26.900"] = "<1:message>."
  Secondary["26.901"] = "Result of a method call did not result in a whole number; found ""<1:value>""."
  Secondary["26.902"] = "Result of a COMPARETO method call did not result in a whole number; found ""<1:value>""."
  Secondary["26.903"] = "Result of a COMPARE method call did not result in a whole number; found ""<1:value>""."
  Secondary["26.904"] = "Stem ""<1:stem>"" element 0 is not a whole number; found ""<2:count>""."
  Secondary["27.001"] = "Only one WHILE or UNTIL condition can be used on the same loop."
  Secondary["27.901"] = "Incorrect data following FOREVER keyword on the loop; found ""<1:data>""."
  Secondary["27.902"] = "DO or LOOP keyword <1:keyword> can be specified only once."
  Secondary["27.903"] = "No INDEX or ITEM control variable specified on a WITH loop."
  Secondary["27.904"] = "OVER keyword expected for a WITH loop."
  Secondary["27.905"] = "COUNTER keyword not allowed on a simple DO instruction."
  Secondary["28.001"] = "LEAVE is valid only within a repetitive loop or labeled block instruction."
  Secondary["28.002"] = "ITERATE is valid only within a repetitive loop."
  Secondary["28.003"] = "Symbol following LEAVE (""<1:symbol>"") must either match the label of a current loop or block instruction."
  Secondary["28.004"] = "Symbol following ITERATE (""<1:symbol>"") must either match the label of a current loop or be omitted."
  Secondary["28.005"] = "Symbol following ITERATE (""<1:symbol>"") does not match a repetitive block instruction."
  Secondary["29.001"] = "Environment name exceeds <1:limit> characters; found ""<2:environment_name>""."
  Secondary["30.001"] = "Name or symbol exceeds 250 characters: ""<1:name>""."
  Secondary["30.900"] = "<1:message>."
  Secondary["31.001"] = "A value cannot be assigned to a number; found ""<1:number>""."
  Secondary["31.002"] = "Variable symbol must not start with a number; found ""<1:symbol>""."
  Secondary["31.003"] = "Variable symbol must not start with a "".""; found ""<1:symbol>""."
  Secondary["31.900"] = "<1:message>."
  Secondary["33.001"] = "Value of NUMERIC DIGITS (""<1:value>"") must exceed value of NUMERIC FUZZ (""<2:value>"")."
  Secondary["33.002"] = "Value of NUMERIC DIGITS (""<1:value>"") must not exceed <2:value>."
  Secondary["33.900"] = "<1:message>."
  Secondary["33.901"] = "Incorrect expression result following VALUE keyword of ADDRESS instruction."
  Secondary["33.902"] = "Incorrect expression result following VALUE keyword of SIGNAL instruction."
  Secondary["33.903"] = "Incorrect expression result following VALUE keyword of TRACE instruction."
  Secondary["33.904"] = "Incorrect expression result following SYNTAX keyword of RAISE instruction."
  Secondary["34.001"] = "Value of expression following IF keyword must be exactly ""0"" or ""1""; found ""<1:value>""."
  Secondary["34.002"] = "Value of expression following WHEN keyword must be exactly ""0"" or ""1""; found ""<1:value>""."
  Secondary["34.003"] = "Value of expression following WHILE keyword must be exactly ""0"" or ""1""; found ""<1:value>""."
  Secondary["34.004"] = "Value of expression following UNTIL keyword must be exactly ""0"" or ""1""; found ""<1:value>""."
  Secondary["34.005"] = "Value of expression to the left of the logical operator ""<1:operator>"" must be exactly ""0"" or ""1""; found ""<2:value>""."
  Secondary["34.006"] = "Value of logical list expression element must be exactly ""0"" or ""1""; found ""<1:value>""."
  Secondary["34.900"] = "<1:message>."
  Secondary["34.901"] = "Logical value must be exactly ""0"" or ""1""; found ""<1:value>""."
  Secondary["34.902"] = "Value of expression following GUARD keyword must be exactly ""0"" or ""1""; found ""<1:value>""."
  Secondary["34.903"] = "Authorization return value must be exactly ""0"" or ""1""; found ""<1:value>""."
  Secondary["34.904"] = "Property logical value must be exactly ""0"", ""1"", ""true"", or ""false""; found ""<1:value>""."
  Secondary["34.905"] = "SELECT CASE comparison result must be exactly ""0"" or ""1""; found ""<1:value>""."
  Secondary["34.906"] = "Supplier AVAILABLE method did not return exactly ""0"" or ""1""; found ""<1:value>""."
  Secondary["35.001"] = "Incorrect expression detected at ""<1:token>""."
  Secondary["35.900"] = "<1:message>."
  Secondary["35.901"] = "Prefix operator ""<1:operator>"" is not followed by an expression term."
  Secondary["35.902"] = "Missing conditional expression following IF keyword."
  Secondary["35.903"] = "Missing conditional expression following WHEN keyword."
  Secondary["35.904"] = "Missing initial expression for DO or LOOP control variable."
  Secondary["35.905"] = "Missing expression following BY keyword."
  Secondary["35.906"] = "Missing expression following TO keyword."
  Secondary["35.907"] = "Missing expression following FOR keyword."
  Secondary["35.908"] = "Missing expression following WHILE keyword."
  Secondary["35.909"] = "Missing expression following UNTIL keyword."
  Secondary["35.911"] = "Missing expression following OVER keyword."
  Secondary["35.912"] = "Missing expression following INTERPRET keyword."
  Secondary["35.913"] = "Missing expression following OPTIONS keyword."
  Secondary["35.914"] = "Missing expression following VALUE keyword of an ADDRESS instruction."
  Secondary["35.915"] = "Missing expression following VALUE keyword of a SIGNAL instruction."
  Secondary["35.916"] = "Missing expression following VALUE keyword of a TRACE instruction."
  Secondary["35.917"] = "Missing expression following VALUE keyword of a NUMERIC FORM instruction."
  Secondary["35.918"] = "Missing expression following assignment instruction."
  Secondary["35.919"] = "Operator ""<1:operator>"" is not followed by an expression term."
  Secondary["35.921"] = "Missing expression following GUARD keyword."
  Secondary["35.922"] = "Missing expression following DESCRIPTION keyword of a RAISE instruction."
  Secondary["35.923"] = "Missing expression following ADDITIONAL keyword of a RAISE instruction."
  Secondary["35.924"] = "Missing ""("" on expression list of the ARRAY keyword."
  Secondary["35.925"] = "Missing expression following TO keyword of a FORWARD instruction."
  Secondary["35.926"] = "Missing expression following ARGUMENTS keyword of a FORWARD instruction."
  Secondary["35.927"] = "Missing expression following MESSAGE keyword of a FORWARD instruction."
  Secondary["35.928"] = "Missing expression following CLASS keyword of a FORWARD instruction."
  Secondary["35.929"] = "Missing expression in logical expression list."
  Secondary["35.930"] = "Invalid or missing expression following ""="" token of a USE ARG instruction."
  Secondary["35.931"] = "Missing expression following ""("" of parse template."
  Secondary["35.932"] = "Missing expression for calculated CALL name."
  Secondary["35.933"] = "Missing expression following CASE keyword of a SELECT instruction."
  Secondary["35.934"] = "Missing expression in WHEN case expression list."
  Secondary["35.935"] = "Missing expression following <1:keyword> keyword of a <2:instruction> instruction."
  Secondary["35.936"] = "Missing expression on ::CONSTANT directive."
  Secondary["36.900"] = "<1:message>."
  Secondary["36.901"] = "Left parenthesis ""("" in position <1:position> on line <2:line_number> requires a corresponding right parenthesis "")""."
  Secondary["36.902"] = "Square bracket ""["" in position <1:position> on line <2:line_number> requires a corresponding right square bracket ""]""."
  Secondary["37.001"] = "Unexpected "",""."
  Secondary["37.002"] = "Unmatched "")"" in expression."
  Secondary["37.900"] = "<1:message>."
  Secondary["37.901"] = "Unexpected ""]""."
  Secondary["38.001"] = "Incorrect PARSE template detected at ""<1:column_position>""."
  Secondary["38.002"] = "Incorrect PARSE position detected at ""<1:column_position>""."
  Secondary["38.003"] = "PARSE VALUE instruction requires WITH keyword."
  Secondary["38.900"] = "<1:message>."
  Secondary["38.901"] = "Missing PARSE relative position."
  Secondary["40.001"] = "External routine ""<1:routine>"" failed."
  Secondary["40.003"] = "Not enough arguments in invocation of <1:routine>; minimum expected is <2:number>."
  Secondary["40.004"] = "Too many arguments in invocation of <1:routine>; maximum expected is <2:number>."
  Secondary["40.005"] = "Missing argument in invocation of <1:routine>; argument <2:argument_number> is required."
  Secondary["40.011"] = "<1:function_name> argument <2:argument_number> must be a number; found ""<3:value>""."
  Secondary["40.012"] = "<1:function_name> argument <2:argument_number> must be a whole number; found ""<3:value>""."
  Secondary["40.013"] = "<1:function_name> argument <2:argument_number> must be zero or positive; found ""<3:value>""."
  Secondary["40.014"] = "<1:function_name> argument <2:argument_number> must be positive; found ""<3:value>""."
  Secondary["40.019"] = "<1:function_name> argument 2, ""<2:value>"", is not in the format described by argument 3, ""<3:value>""."
  Secondary["40.021"] = "<1:function_name> argument <2:argument_number> must not be a null string."
  Secondary["40.022"] = "<1:function_name> argument <2:argument_number> must be a single character or null; found ""<3:value>""."
  Secondary["40.023"] = "<1:function_name> argument <2:argument_number> must be a single character; found ""<3:value>""."
  Secondary["40.024"] = "<1:function_name> argument <2:argument_number> must be a binary string; found ""<3:value>""."
  Secondary["40.025"] = "<1:function_name> argument <2:argument_number> must be a hexadecimal string; found ""<3:value>""."
  Secondary["40.026"] = "<1:function_name> argument <2:argument_number> must be a valid symbol; found ""<3:value>""."
  Secondary["40.027"] = "<1:function_name> argument 1 must be a valid stream name; found ""<2:value>""."
  Secondary["40.028"] = "<1:function_name> argument <2:argument_number> must be a character class name or a single character; found ""<3:value>""."
  Secondary["40.029"] = "<1:function_name> conversion to format ""<2:value>"" is not allowed."
  Secondary["40.032"] = "RANDOM difference between argument 1 (""<1:value>"") and argument 2 (""<2:value>"") must not exceed 999,999,999."
  Secondary["40.033"] = "RANDOM argument 1 (""<1:argument>"") must be less than or equal to argument 2 (""<2:argument>"")."
  Secondary["40.034"] = "SOURCELINE argument 1 (""<1:argument>"") must be less than or equal to the number of lines in the program (<2:argument>)."
  Secondary["40.035"] = "X2D argument 1 cannot be expressed as a whole number; found ""<1:value>""."
  Secondary["40.043"] = "<1:function_name> argument <2:number> must be a single non-alphanumeric character or the null string; found ""<3:value>""."
  Secondary["40.044"] = "<1:function_name> argument <2:number>, ""<3:value>"", is a format incompatible with the separator specified in argument <4:number>."
  Secondary["40.900"] = "<1:message>."
  Secondary["40.901"] = "Result returned by <1:routine> is longer than <2:length>: ""<3:value>""."
  Secondary["40.902"] = "<1:function_name> argument <2:argument_number> must not exceed the whole number limit."
  Secondary["40.903"] = "<1:function_name> argument <2:argument_number> must be in the range 0-99; found ""<3:value>""."
  Secondary["40.904"] = "<1:function_name> argument <2:argument_number> must be one of <3:values>; found ""<4:value>""."
  Secondary["40.905"] = "TRACE setting letter must be one of ""ACEFILNOR""; found ""<1:value>""."
  Secondary["40.912"] = "<1:function_name> argument <2:argument_number> must be a single-dimensional array; found ""<3:value>""."
  Secondary["40.913"] = "<1:function_name> argument <2:argument_number> must have a string value; found ""<3:value>""."
  Secondary["40.914"] = "Unknown VALUE function variable environment selector; found ""<1:value>""."
  Secondary["40.915"] = "<1:function_name> cannot be used with QUEUE:."
  Secondary["40.916"] = "Cannot read from a write-only property."
  Secondary["40.917"] = "Cannot write to a read-only property or typelib element."
  Secondary["40.918"] = "Invalid native function signature specification."
  Secondary["40.919"] = "Argument <1:argument> must have a stem object or stem name value; found ""<2:value>""."
  Secondary["40.920"] = "<1:function_name> argument <2:name> must be one of <3:option>; found ""<4:value>""."
  Secondary["40.921"] = "Argument <1:first option> (""<2:first value>"") must be greater than argument <3:second option> (""<4:second value>"")."
  Secondary["40.922"] = "Stem argument does not have a valid count for element 0."
  Secondary["40.923"] = "The operation is outside the size of the stem array (""<1:value>"")."
  Secondary["40.924"] = "Stem element at position ""<1:position>"" is not set."
  Secondary["40.925"] = "Argument <1:argument> must be an array object, a stem object, or a stem name value; found ""<2:value>""."
  Secondary["41.001"] = "Nonnumeric value (""<1:value>"") used in arithmetic operation."
  Secondary["41.003"] = "Nonnumeric value (""<1:value>"") used with prefix operator."
  Secondary["41.004"] = "Value of TO expression of DO or LOOP instruction must be numeric; found ""<1:value>""."
  Secondary["41.005"] = "Value of BY expression of DO or LOOP instruction must be numeric; found ""<1:value>""."
  Secondary["41.006"] = "Value of control variable expression of DO or LOOP instruction must be numeric; found ""<1:value>""."
  Secondary["41.007"] = "Exponent exceeds <1:number> digits; found ""<2:value>""."
  Secondary["41.900"] = "<1:message>."
  Secondary["41.901"] = "Value of RAISE instruction SYNTAX expression must be numeric; found ""<1:value>""."
  Secondary["42.001"] = "Arithmetic overflow detected at: ""<1:value><2:operator><3:value>""."
  Secondary["42.002"] = "Arithmetic underflow detected at: ""<1:value><2:operator><3:value>""."
  Secondary["42.003"] = "Arithmetic overflow; divisor must not be zero."
  Secondary["42.900"] = "<1:message>."
  Secondary["42.901"] = "Arithmetic overflow; exponent (""<1:exponent>"") exceeds <2:number> digits."
  Secondary["42.902"] = "Arithmetic underflow; exponent (""<1:exponent>"") exceeds <2:number> digits."
  Secondary["42.903"] = "Arithmetic underflow; zero raised to a negative power."
  Secondary["43.001"] = "Could not find routine ""<1:routine>""."
  Secondary["43.900"] = "<1:message>."
  Secondary["43.901"] = "Could not find file ""<1:file>"" for ::REQUIRES."
  Secondary["43.902"] = "Routine ""<1:routineName>"" not found in namespace ""<2:namespace>""."
  Secondary["44.001"] = "No data returned from function ""<1:function>""."
  Secondary["44.900"] = "<1:message>."
  Secondary["45.001"] = "Data expected on RETURN instruction because routine ""<1:routine>"" was called as a function."
  Secondary["46.001"] = "Extra token (""<1:token>"") found in variable reference list; "")"" expected."
  Secondary["46.900"] = "<1:message>."
  Secondary["46.901"] = "Missing "")"" in variable reference."
  Secondary["46.902"] = "Extra token (""<1:token>"") found in USE ARG variable reference; "","" or end of instruction expected."
  Secondary["47.001"] = "INTERPRET data must not contain labels; found ""<1:label>""."
  Secondary["47.002"] = "Labels are not allowed within a DO/LOOP block; found ""<1:label>""."
  Secondary["47.003"] = "Labels are not allowed within an IF block; found ""<1:label>""."
  Secondary["47.004"] = "Labels are not allowed within a SELECT block; found ""<1:label>""."
  Secondary["48.001"] = "Failure in system service: <1:service>."
  Secondary["48.900"] = "<1:message>."
  Secondary["49.001"] = "Interpretation error: unexpected failure initializing the interpreter."
  Secondary["49.002"] = "Interpretation error: unmatched <1:type> <2:number>."
  Secondary["49.900"] = "<1:message>."
  Secondary["88.900"] = "<1:message>."
  Secondary["88.901"] = "Missing argument; argument <1:argument> is required."
  Secondary["88.902"] = "The <1:argument> argument must be a number; found ""<2:value>""."
  Secondary["88.903"] = "The <1:argument> argument must be a whole number; found ""<2:value>""."
  Secondary["88.904"] = "The <1:argument> argument must be zero or a positive whole number; found ""<2:value>""."
  Secondary["88.905"] = "Argument <1:argument> must be a positive whole number; found ""<2:value>""."
  Secondary["88.906"] = "Argument <1:argument> must not exceed <2:limit>; found ""<3:value>""."
  Secondary["88.907"] = "Argument <1:argument> must be in the range <2:min> to <3:max>; found ""<4:value>""."
  Secondary["88.908"] = "Argument <1:argument> must not be a null string."
  Secondary["88.909"] = "Argument <1:argument> must have a string value."
  Secondary["88.910"] = "Argument <1:argument> is an invalid pad or character argument; found ""<2:value>""."
  Secondary["88.911"] = "Argument <1:argument> is an invalid length value; found ""<2:value>""."
  Secondary["88.912"] = "Argument <1:argument> is an invalid position value; found ""<2:value>""."
  Secondary["88.913"] = "Argument <1:argument> must be a single-dimensional array."
  Secondary["88.914"] = "Argument <1:argument> must be an instance of the <2:class> class."
  Secondary["88.915"] = "Argument <1:argument> could not be converted to a <2:type> type."
  Secondary["88.916"] = "Argument <1:argument> must be one of <2:values>; found ""<3:value>""."
  Secondary["88.917"] = "Argument <1:argument> <2:reason>."
  Secondary["88.918"] = "Argument <1:argument> is not in a valid format; found ""<2:value>""."
  Secondary["88.919"] = "Argument <1:argument> is not in valid pointer format; found ""<2:value>""."
  Secondary["88.920"] = "Argument <1:argument> must be a stem object or stem name; found ""<2:value>""."
  Secondary["88.921"] = "Argument <1:argument> must be a valid double value; found ""<2:value>""."
  Secondary["88.922"] = "Too many arguments in invocation; <1:number> expected."
  Secondary["88.923"] = "<1:name> argument <2:argument_number> must be a single-dimensional array; found ""<3:value>""."
  Secondary["88.924"] = "<1:name> argument <2:argument_number> must be an array with exactly <3:count> items."
  Secondary["88.925"] = "The <1:argument> argument must be zero or a positive number; found ""<2:value>""."
  Secondary["88.926"] = "The <1:argument> argument must be a positive number; found ""<2:value>""."
  Secondary["88.927"] = "The <1:argument> argument must be exactly ""0"" or ""1""; found ""<2:value>""."
  Secondary["88.928"] = "The <1:argument> argument must be a VariableReference instance; found ""<2:value>""."
  Secondary["88.929"] = "The <1:argument> argument must be a VariableReference for a Stem variable; found ""<2:value>""."
  Secondary["88.930"] = "The <1:argument> argument must be a VariableReference for a simple variable; found ""<2:value>""."
  Secondary["88.931"] = "Argument <1:argument> was omitted. A VariableReference argument is required."
  Secondary["88.932"] = "Date template <1:template> contains an invalid pattern; found ""<2:value>""."
  Secondary["88.933"] = "Unable to parse date ""<1:date>"" with template ""<2:template>""."
  Secondary["89.001"] = "The USE instruction requires a comma-separated list of variables or assignment message terms."
  Secondary["89.002"] = "The PARSE instruction was expecting a variable or a message term."
  Secondary["90.900"] = "<1:message>."
  Secondary["90.997"] = "Unable to find external class ""<1:class>""."
  Secondary["90.998"] = "Unable to find external method ""<1:method>""."
  Secondary["90.999"] = "Unable to find external routine ""<1:routine>""."
  Secondary["91.900"] = "<1:message>."
  Secondary["91.999"] = "Message ""<1:message>"" did not return a result."
  Secondary["92.900"] = "<1:message>."
  Secondary["92.901"] = "An unknown OLE error occurred (HRESULT=<1:hresult>)."
  Secondary["92.902"] = "Cannot convert OLE VARIANT to REXX object: The conversion of the VARIANT type <1:varianttype> into a REXX object failed."
  Secondary["92.903"] = "Cannot convert REXX object to OLE VARIANT: The conversion of <1:rexx_object> into a VARIANT failed."
  Secondary["92.904"] = "The number of elements provided to the method or property is different from the number of parameters accepted by it."
  Secondary["92.905"] = "One of the parameters is not a valid VARIANT type."
  Secondary["92.906"] = "OLE exception: <1:exc_name>."
  Secondary["92.907"] = "The requested method does not exist, or you tried to set the value of a read-only property."
  Secondary["92.908"] = "One of the parameters could not be coerced to the desired type."
  Secondary["92.909"] = "One or more of the parameters could not be coerced to the desired type. The first parameter with incorrect type is argument <1:index>."
  Secondary["92.910"] = "A required parameter was omitted."
  Secondary["92.911"] = "Could not create OLE instance."
  Secondary["92.912"] = "The object invoked has disconnected from its clients."
  Secondary["93.900"] = "<1:message>."
  Secondary["93.901"] = "Not enough arguments for method; <1:number> expected."
  Secondary["93.902"] = "Too many arguments in invocation of method; <1:number> expected."
  Secondary["93.903"] = "Missing argument in method; argument <1:argument> is required."
  Secondary["93.904"] = "Method argument <1:argument> must be a number; found ""<2:value>""."
  Secondary["93.905"] = "Method argument <1:argument> must be a whole number; found ""<2:value>""."
  Secondary["93.906"] = "Method argument <1:argument> must be zero or a positive whole number; found ""<2:value>""."
  Secondary["93.907"] = "Method argument <1:argument> must be a positive whole number; found ""<2:value>""."
  Secondary["93.908"] = "Method argument <1:argument> must not exceed <2:limit>; found ""<3:value>""."
  Secondary["93.909"] = "Method argument <1:argument> must be in the range 0-99; found ""<2:value>""."
  Secondary["93.911"] = "Method argument <1:argument> must not be null."
  Secondary["93.912"] = "Method argument <1:argument> must be a hexadecimal string; found ""<2:value>""."
  Secondary["93.913"] = "Method argument <1:argument> must be a valid symbol; found ""<2:value>""."
  Secondary["93.914"] = "Method argument <1:argument> must be one of <2:arguments>; found ""<3:value>""."
  Secondary["93.915"] = "Method option must be one of ""<1:arguments>""; found ""<2:value>""."
  Secondary["93.917"] = "Method <1:method> does not exist."
  Secondary["93.918"] = "Incorrect list index ""<1:index>""."
  Secondary["93.919"] = "Incorrect array position ""<1:position>""."
  Secondary["93.921"] = "Argument missing on binary operator."
  Secondary["93.922"] = "Incorrect pad or character argument specified; found ""<1:value>""."
  Secondary["93.923"] = "Invalid length argument specified; found ""<1:value>""."
  Secondary["93.924"] = "Invalid position argument specified; found ""<1:value>""."
  Secondary["93.925"] = "Not enough subscripts for array; <1:number> expected."
  Secondary["93.926"] = "Too many subscripts for array; <1:number> expected."
  Secondary["93.927"] = "Length must be specified to convert a negative value."
  Secondary["93.928"] = "D2X value must be a valid whole number; found ""<1:value>""."
  Secondary["93.929"] = "D2C value must be a valid whole number; found ""<1:value>""."
  Secondary["93.931"] = "Incorrect location of whitespace character in position <1:position> in hexadecimal string."
  Secondary["93.932"] = "Incorrect location of whitespace character in position <1:position> in binary string."
  Secondary["93.933"] = "Only 0-9, a-f, A-F, and whitespace characters are valid in a hexadecimal string; character found ""<1:character>""."
  Secondary["93.934"] = "Only 0, 1, and whitespace characters are valid in a binary string; character found ""<1:character>""."
  Secondary["93.935"] = "X2D result is not a valid whole number with NUMERIC DIGITS <1:digits>."
  Secondary["93.936"] = "C2D result is not a valid whole number with NUMERIC DIGITS <1:digits>."
  Secondary["93.937"] = "No more supplier items available."
  Secondary["93.938"] = "Method argument <1:argument> must have a string value."
  Secondary["93.939"] = "Method argument <1:argument> must have a single-dimensional array value."
  Secondary["93.940"] = "<1:method> method target must be a whole number; found ""<2:value>""."
  Secondary["93.941"] = "Exponent of ""<1:exponent>"" is too large for <2:number> spaces."
  Secondary["93.942"] = "Integer part of ""<1:integer>"" is too large for <2:number> spaces."
  Secondary["93.943"] = "<1:method> method target must be a number; found ""<2:value>""."
  Secondary["93.944"] = "Method argument <1:argument> must be a message object."
  Secondary["93.945"] = "Missing argument in message array; argument <1:argument> is required."
  Secondary["93.946"] = "A message array must be a single-dimensional array with 2 elements."
  Secondary["93.947"] = "Method SECTION can be used only on single-dimensional arrays."
  Secondary["93.948"] = "Method argument <1:argument> must be of the <2:class> class."
  Secondary["93.949"] = "The value and index objects must be the same for PUT to an index-only collection."
  Secondary["93.951"] = "Incorrect alarm time; found ""<1:time>""."
  Secondary["93.952"] = "Method argument <1:argument> is an array and does not contain all string values."
  Secondary["93.953"] = "Method argument <1:argument> could not be converted to type <2:type>."
  Secondary["93.954"] = "Method ""<1:method>"" can be used only on a single-dimensional array."
  Secondary["93.956"] = "Element <1:element> of the array must be a string."
  Secondary["93.957"] = "Target object ""<1:object>"" is not a subclass of the message override scope (<2:scope>)."
  Secondary["93.958"] = "Positioning of transient streams is not valid."
  Secondary["93.959"] = "An array cannot contain more than <1:size> elements."
  Secondary["93.961"] = "The <1:argument> argument must be a string or array object."
  Secondary["93.962"] = "Invalid Base64 encoded string."
  Secondary["93.963"] = "Call to unsupported or unimplemented method."
  Secondary["93.964"] = "Application error: <1:message>."
  Secondary["93.965"] = "Method <1:name> is ABSTRACT and cannot be directly invoked."
  Secondary["93.966"] = "Incorrect queue index ""<1:index>""."
  Secondary["93.967"] = "NEW method is not supported for the <1:name> class."
  Secondary["93.968"] = "Invalid native method signature specification."
  Secondary["93.969"] = "Method argument <1:argument> must have a stem object value; found ""<2:value>""."
  Secondary["93.970"] = "COPY method is not supported for object <1:object>."
  Secondary["93.971"] = "Method argument <1:argument> cannot have more than a single dimension."
  Secondary["93.972"] = "A message name argument must be a string or an array with 2 elements; found ""<1:value>""."
  Secondary["93.973"] = "ORDERABLE comparison method ""<1:method>"" argument cannot be .nil."
  Secondary["93.974"] = "The <1:argument> argument must be a string, array, or method object."
  Secondary["93.975"] = "Invalid <1:option> value; found ""<2:value>""."
  Secondary["93.976"] = "Hexadecimal strings must be grouped in units that are multiples of two characters."
  Secondary["93.977"] = "Binary strings must be grouped in units that are multiples of four characters."
  Secondary["93.978"] = "Method argument <1:argument> could not be converted to type <2:type>; found ""<3:value>""."
  Secondary["97.001"] = "Object ""<1:object>"" does not understand message ""<2:message>""."
  Secondary["97.002"] = "Object ""<1:object>"" cannot accept private message ""<2:message>"" from this context."
  Secondary["97.003"] = "Object ""<1:object>"" cannot accept package scope message ""<2:message>"" from a different package caller."
  Secondary["97.004"] = "Constant ""<2:name>"" of object ""<1:object>"" has not been initialized."
  Secondary["97.005"] = "An unhandled NOMETHOD condition has been raised."
  Secondary["97.900"] = "<1:message>."
  Secondary["98.900"] = "<1:message>."
  Secondary["98.901"] = "Object ""<1:object>"" was not correctly initialized."
  Secondary["98.902"] = "Unable to convert object ""<1:object>"" to a double-float value."
  Secondary["98.903"] = "Unable to load library ""<1:name>""."
  Secondary["98.904"] = "Abnormal termination occurred."
  Secondary["98.905"] = "Deadlock detected on a guarded method."
  Secondary["98.906"] = "Incorrect object reference detected."
  Secondary["98.907"] = "Object of type ""<1:type>"" was required."
  Secondary["98.908"] = "Metaclass ""<1:metaclass>"" not found."
  Secondary["98.909"] = "Class ""<1:class>"" not found."
  Secondary["98.911"] = "Cyclic inheritance in program ""<1:program>""."
  Secondary["98.913"] = "Unable to convert object ""<1:object>"" to a single-dimensional array value."
  Secondary["98.914"] = "Unable to convert object ""<1:object>"" to a string value."
  Secondary["98.915"] = "A message object that was sent a START message cannot be sent another START, SEND, or REPLY message."
  Secondary["98.916"] = "Message object ""<1:object>"" received an error from message ""<2:message>""."
  Secondary["98.917"] = "Incorrect condition object received for RAISE OBJECT; found ""<1:value>""."
  Secondary["98.918"] = "No active condition available for PROPAGATE."
  Secondary["98.919"] = "Unable to convert object ""<1:object>"" to a method."
  Secondary["98.920"] = "Unable to open file ""<1:file>"" for writing; open result was ""<2:error>""."
  Secondary["98.921"] = "Address environment ""<1:address>"" does not support input/output redirection."
  Secondary["98.922"] = "REPLACE or APPEND cannot be specified with a RexxQueue object USING target."
  Secondary["98.923"] = "Address command redirection failed (<1:oserror>)."
  Secondary["98.924"] = "Object ""<1:object>"" is not a valid ADDRESS WITH INPUT source."
  Secondary["98.935"] = "REPLY can be issued only once per method invocation."
  Secondary["98.936"] = "RETURN cannot return a value after a REPLY."
  Secondary["98.937"] = "EXIT cannot return a value after a REPLY."
  Secondary["98.938"] = "Message search overrides can be used only from methods of the target object."
  Secondary["98.939"] = "Additional information for SYNTAX errors must be a single-dimensional array of values."
  Secondary["98.941"] = "Unknown error number specified on RAISE SYNTAX; found ""<1:number>""."
  Secondary["98.942"] = "Class ""<1:class>"" must be a MIXINCLASS for INHERIT."
  Secondary["98.943"] = "Class ""<1:class>"" is not a subclass of ""<2:class>"" base class ""<3:class>""."
  Secondary["98.944"] = "Class ""<1:class>"" cannot inherit from itself, a superclass, or a subclass (""<2:class>"")."
  Secondary["98.945"] = "Class ""<1:class>"" has not inherited class ""<2:class>""."
  Secondary["98.946"] = "FORWARD arguments must be a single-dimensional array of values."
  Secondary["98.947"] = "FORWARD can only be issued in an object method invocation."
  Secondary["98.948"] = "Authorization failure: <1:value>."
  Secondary["98.951"] = "Concurrency not supported."
  Secondary["98.952"] = "Circular ::REQUIRES references detected with <1:name>."
  Secondary["98.970"] = "External command ""<1:command>"" ended with return code <2:rc>."
  Secondary["98.971"] = "External command ""<1:command>"" failed with return code <2:rc>."
  Secondary["98.972"] = "Number <1:number> has more digits than the current precision."
  Secondary["98.973"] = "Object ""<1:object>"" does not have a string representation."
  Secondary["98.974"] = "Stream ""<1:object>"" is not ready."
  Secondary["98.975"] = "Missing array element at position <1:position>."
  Secondary["98.976"] = "Stem object default value cannot be another stem object."
  Secondary["98.978"] = "Unable to load method ""<1:name>"" from library ""<2:library>""."
  Secondary["98.979"] = "Unable to load routine ""<1:name>"" from library ""<2:library>""."
  Secondary["98.980"] = "Unable to load native routine ""<1:name>""."
  Secondary["98.981"] = "Target RexxContext is no longer active."
  Secondary["98.982"] = "Library ""<1:name>"" is not compatible with current interpreter version."
  Secondary["98.983"] = "Execution thread does not match API thread context."
  Secondary["98.984"] = "User additions are not allowed to the REXX package."
  Secondary["98.985"] = "User additions are not allowed to the REXX language classes."
  Secondary["98.986"] = "Reference to unassigned variable ""<1:name>""."
  Secondary["98.987"] = "Namespace ""<1:namespace>"" not found in package ""<2:package>""."
  Secondary["98.988"] = "Class ""<1:className>"" not found in namespace ""<2:namespace>""."
  Secondary["98.989"] = "Class <1:name> is ABSTRACT and cannot be directly created."
  Secondary["98.990"] = "Class <1:name> is a metaclass and cannot be made ABSTRACT."
  Secondary["98.991"] = "Method <1:name> may only be invoked from a method of the same object or one of its classes."
  Secondary["98.992"] = "The EXPOSE instruction may only be used from method invocations."
  Secondary["98.993"] = "The USE LOCAL instruction may only be used from method invocations."
  Secondary["98.994"] = "Unable to convert object ""<1:object>"" to a supplier object."
  Secondary["98.995"] = "Unable to reference variable ""<1:object>""; it must be an uninitialized local variable."
  Secondary["98.996"] = "Object ""<1:object>"" is not a valid ADDRESS WITH OUTPUT or ERROR target."
  Secondary["98.997"] = "REPLACE or APPEND cannot be specified with a Stream object USING target."
  Secondary["98.998"] = "Stem ""<1:object>"" does not contain a size count in element 0."
  Secondary["98.999"] = "Unable to open file ""<1:file>"" for reading; open result was ""<2:error>""."
  Secondary["99.900"] = "<1:message>."
  Secondary["99.901"] = "Duplicate ::CLASS directive instruction."
  Secondary["99.902"] = "Duplicate ::METHOD directive instruction."
  Secondary["99.903"] = "Duplicate ::ROUTINE directive instruction."
  Secondary["99.904"] = "Duplicate ::REQUIRES directive instruction."
  Secondary["99.905"] = "CLASS keyword on ::METHOD directive requires a matching ::CLASS directive."
  Secondary["99.906"] = "A ::CONSTANT directive with an expression requires a matching ::CLASS directive."
  Secondary["99.907"] = "EXPOSE must be the first instruction executed after a method invocation."
  Secondary["99.908"] = "INTERPRET data must not contain EXPOSE."
  Secondary["99.909"] = "GUARD must be the first instruction executed after EXPOSE or USE."
  Secondary["99.910"] = "USE LOCAL must be the first instruction executed after a method invocation."
  Secondary["99.911"] = "GUARD can only be issued in an object method invocation."
  Secondary["99.912"] = "INTERPRET data must not contain GUARD."
  Secondary["99.913"] = "GUARD instruction did not include references to exposed variables."
  Secondary["99.914"] = "INTERPRET data must not contain directive instructions."
  Secondary["99.915"] = "INTERPRET data must not contain USE LOCAL."
  Secondary["99.916"] = "Unrecognized directive instruction."
  Secondary["99.917"] = "Incorrect external name specification ""<1:name>""."
  Secondary["99.918"] = "USE ARG requires a "","" between variable names; found ""<1:token>""."
  Secondary["99.919"] = "REPLY can only be issued in an object method invocation."
  Secondary["99.921"] = "Incorrect program line in method source array."
  Secondary["99.922"] = "::REQUIRES directives must appear before other directive instructions."
  Secondary["99.923"] = "INTERPRET data must not contain FORWARD."
  Secondary["99.924"] = "INTERPRET data must not contain REPLY."
  Secondary["99.925"] = "An ATTRIBUTE method name must be a valid variable name; found ""<1:name>""."
  Secondary["99.926"] = "Incorrect class external; too many parameters."
  Secondary["99.927"] = """<1:classname>"" is not a valid metaclass."
  Secondary["99.928"] = "Incorrect class external; class name missing or invalid."
  Secondary["99.929"] = "Incorrect class external; invalid class server ""<1:servername>""."
  Secondary["99.930"] = "The ""..."" argument marker can only appear at the end of the argument list."
  Secondary["99.931"] = "Duplicate ::ATTRIBUTE directive instruction."
  Secondary["99.932"] = "Duplicate ::CONSTANT directive instruction."
  Secondary["99.933"] = "Abstract methods cannot have a method body."
  Secondary["99.934"] = "Attribute methods cannot have a method body."
  Secondary["99.935"] = "External attributes cannot have a method body."
  Secondary["99.936"] = "External methods cannot have a method body."
  Secondary["99.937"] = "Attribute methods without a SET or GET designation cannot have a method body."
  Secondary["99.938"] = "Constant methods cannot have a method body."
  Secondary["99.939"] = "External routines cannot have a code body."
  Secondary["99.940"] = "Abstract attributes cannot have a method body."
  Secondary["99.941"] = "Method or routine code may not contain directive instructions."
  Secondary["99.942"] = "Duplicate ::RESOURCE directive instruction."
  Secondary["99.943"] = "Missing ::RESOURCE end marker ""<1:endmarker>"" for resource ""<2:resourcename>""."
  Secondary["99.944"] = "The REXX name is reserved for the language-provided namespace."
  Secondary["99.945"] = "::ANNOTATE target <1:type> ""<2:name>"" not found."
  Secondary["99.946"] = "Delegate methods cannot have a method body."
  Secondary["99.947"] = "Delegate attributes cannot have a method body."
  Secondary["99.948"] = "USE LOCAL cannot process compound variables; found ""<1:variable>""."
  Secondary["99.949"] = """<1:classname>"" is not a valid class."
  Secondary["99.950"] = "A USE ARG default value is not allowed for variable references."

 .environment~ANSI.ErrorText.Secondary = Secondary -- Messages processed: 606

::Routine ANSI.ErrorText Public
  Use Arg code
  Parse Var code major"."minor
  If minor \== "" Then minor = Right(minor, 3, "0")
  If Arg() == 1 Then Do
    If minor == "" Then Return ErrorText(major)
    Return .ANSI.ErrorText.Secondary[major"."minor]
  End
  If minor == "" Then Do
    Say "Routine ANSI.ErrorText called with substitutions but no minor error code."
    Raise HALT
  End
  message = .ANSI.ErrorText.Secondary[major"."minor]
  If Arg(2,"O") Then Return message
  substitutions = Arg(2)
  Do Counter c arg Over substitutions
    If Pos("<"c":",message) == 0 Then Leave
    Parse Var message before ("<"c":") ">"after
    message = before || arg || after
  End
  Return message


-- 606 secondary messages processed.
--
-- Use the following instruction to regenerate secondary message support:
--
--   GenErrorText > ..\ANSI.ErrorText.cls 
