Documentation
=============

---------------------------------

Reference
---------

- [Reference](ref/)
  - [Classes](ref/classes/)
    - [Element](ref/classes/element/)
    - [Driver](ref/classes/driver/)
    - [Highlighter](ref/classes/highlighter/)
    - [Rexx.Parser](ref/classes/rexx.parser/)
    - [StylePatch](ref/classes/stylepatch/)
  - [Element categories](ref/categories/)
  - [Unicode support](unicode/)

User Guide
----------

- [User guide](guide/)
  - [Installation](guide/install/).
  - [First steps](guide/first-steps/).
  - [Error handling](guide/errors/).
  - [The Element API](guide/elementapi/)
  - [The Tree API](guide/treeapi/)

Utilities and samples
---------------------

- [Utilities](utilities/)
  - [Elements](utilities/elements/)
  - [Highlight](utilities/highlight/)
  - [RxCheck](utilities/rxcheck/)
- [Sample programs](samples/)

The Rexx Highlighter
--------------------

- [The Rexx Highlighter](highlighter/)
  - [Common features](highlighter/features/).
  - [The HTML Highlighter](highlighter/html/).
  - [The ANSI Highlighter](highlighter/ansi/).
  - [The (Lua)LaTeX Highlighter](highlighter/latex/).
  - [CGI Installation](highlighter/cgi/).
  - [Exploiting CSS Paged Media](highlighter/paged-media/).

Publications
------------

- [The Rexx Parser](https://www.epbcn.com/pdf/josep-maria-blasco/2025-05-05-The-Rexx-Parser.pdf) (20250505,
  [36th International Rexx Language Symposium -- Vienna, Austria and online](https://www.rexxla.org/events/schedule.rsp?year=2025)).
- [The Rexx Highlighter](https://www.epbcn.com/pdf/josep-maria-blasco/2025-05-06-The-Rexx-Highlighter.pdf) (20250506,
  [36th International Rexx Language Symposium -- Vienna, Austria and online](https://www.rexxla.org/events/schedule.rsp?year=2025)).

Versions
--------

- [Version history](history/).
- [Future versions and to-do list](todo/).

Related ooRexx bugs
-------------------

- [Related ooRexx bugs](oorexx-bugs/).


